/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.test;

import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.sql.DataSource;

public abstract class TestDataSourceSelector {
    private static final String DATABASE_SERVICES_VARIABLE_NAME = "databaseServices";
    private DataSource existingDatabaseService = null;

    public DataSource giveDataSource() {
        if (this.existingDatabaseService == null) {
            String databaseServicePath = System.getProperty(DATABASE_SERVICES_VARIABLE_NAME);
            if (databaseServicePath != null) {
                Map<String, String> databaseProperties = this.readProperties(databaseServicePath);
                if (this.isExternalServiceConfigured(databaseProperties)) {
                    System.out.println("using datasource from file " + databaseServicePath);
                    this.existingDatabaseService = this.buildDataSource(databaseProperties);
                } else {
                    System.out.println("using embedded datasource");
                    this.existingDatabaseService = this.buildEmbeddedDataSource();
                }
            } else {
                System.out.println("using embedded datasource");
                this.existingDatabaseService = this.buildEmbeddedDataSource();
            }
        }
        return this.existingDatabaseService;
    }

    private Map<String, String> readProperties(String databaseServicePath) {
        Properties databaseServiceConf = new Properties();
        try {
            databaseServiceConf.load(new FileReader(databaseServicePath));
        }
        catch (IOException e) {
            throw new RuntimeException("Can't read datasource properties from " + databaseServicePath, e);
        }
        return databaseServiceConf.stringPropertyNames().stream().collect(Collectors.toMap(Function.identity(), databaseServiceConf::getProperty));
    }

    protected abstract boolean isExternalServiceConfigured(Map<String, String> var1);

    protected abstract DataSource buildDataSource(Map<String, String> var1);

    protected abstract DataSource buildEmbeddedDataSource();
}

